<?php
/**
 * Copyright (C) 2014-2023 ServMask Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Kangaroos cannot jump here' );
}

class Ai1wm_Directory {

	/**
	 * Create directory (recursively)
	 *
	 * @param  string  $path Path to the directory
	 * @return boolean
	 */
	public static function create( $path ) {
		if ( @is_dir( $path ) ) {
			return true;
		}

		return @mkdir( $path, 0777, true );
	}

	/**
	 * Delete directory (recursively)
	 *
	 * @param  string  $path Path to the directory
	 * @return boolean
	 */
	public static function delete( $path ) {
		if ( @is_dir( $path ) ) {
			try {
				// Iterate over directory
				$iterator = new Ai1wm_Recursive_Directory_Iterator( $path );

				// Recursively iterate over directory
				$iterator = new Ai1wm_Recursive_Iterator_Iterator( $iterator, RecursiveIteratorIterator::CHILD_FIRST, RecursiveIteratorIterator::CATCH_GET_CHILD );

				// Remove files and directories
				foreach ( $iterator as $item ) {
					if ( $item->isDir() ) {
						@rmdir( $item->getPathname() );
					} else {
						@unlink( $item->getPathname() );
					}
				}
			} catch ( Exception $e ) {
			}

			return @rmdir( $path );
		}

		return false;
	}
}
